<?php
/**
 * Handcrafted meta description check.
 *
 * @since   3.4.0
 * @package SmartCrawl
 */

namespace SmartCrawl\Checks;

/**
 * Class Metadesc_Handcraft
 */
class Metadesc_Handcraft extends Post_Check {

	/**
	 * Holds state reference
	 *
	 * @var bool
	 */
	private $state;

	/**
	 * Get the message for the check.
	 *
	 * @since 3.4.0
	 *
	 * @return string
	 */
	public function get_status_msg() {
		return false === $this->state
			? __( 'Your meta description is autogenerated', 'wds' )
			: __( 'Your meta description is handcrafted', 'wds' );
	}

	/**
	 * Apply check to the subject.
	 *
	 * @since 3.4.0
	 *
	 * @return bool
	 */
	public function apply() {
		// Get custom meta description.
		$custom_meta_desc = \smartcrawl_get_value( 'metadesc', $this->get_post_id() );
		// If it's empty, auto generated meta description is being used.
		$this->state = ! empty( $custom_meta_desc );

		return $this->state;
	}

	/**
	 * Get check result.
	 *
	 * @since 3.4.0
	 *
	 * @return array
	 */
	public function get_result() {
		return array( 'state' => $this->state );
	}
}